<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Unit extends Model 
{

    protected $table = 'units';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'category_id', 'sub_category_id', 'status_id', 'is_active', 'model_type', 'model_id', 'owner_id', 'customer_id');

    public function modelable()
    {
        return $this->morphTo();
    }

    public function location()
    {
        return $this->morphOne('Location', 'model');
    }

    public function status()
    {
        return $this->belongsTo('Status');
    }

    public function files()
    {
        return $this->morphMany('File', 'model');
    }

}